/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
Byte b1,b2; // bytes
/******************************************************************************/
void InitPre()
{
   App.name="Pak Create";
   App.flag=APP_NO_FX;
   PakAdd("../data/engine.pak");
}
/******************************************************************************/
Bool Init()
{
   Text_ds.color =BLACK;
   Text_ds.shadow=0;

   // create Pak from one file/directory
   {
      PakCreate("data"); // create Pak from "data" folder, if no 'pak_name' is specified it will be automatically set (in this case it'll be "data.pak")
   }

   // create Pak from list of files
   {
      Memb<CharMP> list;
      Set(list.New(),"data"      ); // add "data"       directory to the list
      Set(list.New(),"stdafx.h"  ); // add "stdafx.h"   file      to the list
      Set(list.New(),"stdafx.cpp"); // add "stdafx.cpp" file      to the list
      PakCreate(list);              // create Pak from list, 'pak_name' will be automatically set to "Tutorials.pak"
   }

   // create Pak from files in memory
   {
      Memb<WFile> file; // array of file's which we'll create and write to them

      using namespace PakDefs; // use this namespace to simplify Pak creation
      // from now on in current scope:
      // N is a file node Node<PakNode>

      N n; // lets start with main node
      {
         WFile &f=file.New();            // add new file to array, writing constructor will be called automatically
         f.putByte(123);                 // write a Byte to that file
         n.New().set("File 1.dat",f);    // add this file to file nodes
      }
      {
         N &d=(n+="Directory");          // add new directory
         {
            WFile &f=file.New();         // add new file to array, writing constructor will be called automatically
            f.putByte(234);              // write a Byte to that file
            d.New().set("File 2.dat",f); // add this file to directory
         }
      }
      PakCreate(n,"Pak from memory.pak"); // create Pak from nodes
   }

   // load custom Pak
   {
      PakAdd("Pak from memory.pak"); 

      // from now on any data stored in loaded Pak can be accessed through IO methods
      {
         File f1("File 1.dat");           // open the file
         b1=f1.getByte();                 // read Byte from that file

         File f2("Directory/File 2.dat"); // open the file
         b2=f2.getByte();                 // read Byte from that file
      }
   }
   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   return true;
}
/******************************************************************************/
void Draw()
{
   D.clear(WHITE);
   D.text (0,0,S+b1+"  "+b2); // display bytes
}
/******************************************************************************/
